iquitosPlayer = {
	baseDir = "anim/",
	
	name = "avatar",
	mouse = false,
	x = 400,
	y = 300,
	spriteLayer = 3,
	
	baseY = 375.0,
	rangeY = 155.0,
	scaleRange = 0.06,
	
	startZone = "avatar",
	startPoint = "station01",
	
	assets = {
		walkfront = {
			{ state="default", file="walk_front", play="DoSkirt", base=0 },
		},
		walkright = {
			{ state="default", file="walk_right", play="DoSkirt", base=0 },
		},
		walkback = {
			{ state="default", file="walk_back", play="DoSkirt", base=0 },
		},
	},
	children = {
	    mouse = false,
	    left_arm = {
	        name = "avatar_left_arm",
	        layer = -1,
	        assets = {
	            walkfront = {
	                { state = "default", file="walk_front", play="DoLeftArm", base=8, layer=1 },
	                { state = "carry", file="walk_front", play="DoLeftArmCarry", base=40, layer=3 },
	            },
	            walkright = {
	                { state = "default", file="walk_right", play="DoLeftArm", base=42 },
	                { state = "carry", file="walk_right", play="DoLeftArmCarry", base=21 },
	            },
	            walkback = {
	                { state = "default", file="walk_back", play="DoLeftArm", base=10 },
	                { state = "carry", file="walk_back", play="DoLeftArmCarry", base=42 },
	            },
	        },
	    },
	    left_arm_upper = {
	        assets = {
	            walkfront = {
	                { state ="carry", file="walk_front", play ="DoLeftArmUpper", base=24, layer=1 },
	            },
	            walkback = {
	                { state ="carry", file="walk_back", play ="DoLeftArmUpper", base=26, layer=3 },
	            },
	        },
	    },
	    right_arm = {
	        name = "avatar_right_arm",
	        layer = -1,
	        assets = {
	            walkfront = {
	                { state = "default", file="walk_front", play="DoRightArm", base=48, layer=1 },
	                { state = "carry", file="walk_front", play="DoRightArmCarry", base=79, layer=3 },
	            },
	            walkright = {
	                { state = "default", file="walk_right", play="DoRightArm", base=23, layer=3 },
	                { state = "carry", file="walk_right", play="DoRightArmCarry", base=39, layer=3 },
	            },
	            walkback = {
	                { state = "default", file="walk_back", play="DoRightArm", base=49 },
	                { state = "carry", file="walk_back", play="DoRightArmCarry", base=81 },
	            },
	        },
	    },
	    right_arm_upper = {
	        assets = {
	            walkfront = {
	                { state="carry", file="walk_front", play="DoRightArmUpper", base=63, layer=1 },
	            },
	            walkback = {
	                { state="carry", file="walk_back", play="DoRightArmUpper", base=65, layer=3 },
	            },
	        },
	    },
	    torso = {
	        name = "avatar_torso",
	        layer = 2,
	        assets = {
	            walkfront = {
	                { state = "default", file="walk_front", play="DoTorso", base=86 },
	            },
	            walkright = {
	                { state = "default", file="walk_right", play="DoTorso", base=14 },
	            },
	            walkback = {
	                { state = "default", file="walk_back", play="DoTorso", base=88 },
	            },
	        },
	    },
	    idle_1 = {
		    name="avatar_idle_1",
		    assets = {
			    base = {
				    { state="default", file="idle_01", play="DoTopHalf" },
			    },
			},
		    children = {
			    bottom = {
			        layer = -1,
				    name = "bottom",
				    assets = {
					    base = {
						    { state="default", file="idle_01", play="DoBottomHalf" },
					    },
				    },
			    },
		    },
	    },
	    idle_2 = {
		    name="avatar_idle_2",
		    assets = {
			    base = {
				    { state="default", file="idle_02", play="DoTopHalf" },
			    },
			},
		    children = {
			    bottom = {
			        layer = -1,
				    name = "bottom",
				    assets = {
					    base = {
						    { state="default", file="idle_02", play="DoBottomHalf" },
					    },
				    },
			    },
		    },
	    },
	},
}